/*
===============================================================================
Chili is the jQuery code highlighter plugin
...............................................................................
LICENSE: http://www.opensource.org/licenses/mit-license.php
WEBSITE: http://noteslog.com/chili/

                                               Copyright 2008 / Andrea Ercolino
===============================================================================
*/

/* Chili Recipe for Lasso by Jason Huck/Core Five Creative */
{ 
      _name: 'lasso' 
    , _case: false 
    , _main: { 
          multicomment: {  
              _match: /\/\*[^*]*\*+(?:[^\/][^*]*\*+)*\// 
            , _style: 'color: #999;' 
        } 
        , singlecomment: {  
              _match: /\/\/.*/ 
            , _style: 'color: #999;' 
        } 
		, delimiter   : { 
			  _match: /(?:\<\?[Ll][Aa][Ss][Ss][Oo][Ss][Cc][Rr][Ii][Pp][Tt]|\[|\]|\?\>)/
			, _style: 'color: #666;'
		}
		, string1 : { 
			  _match: /\'[^\'\\]*(?:\\.[^\'\\]*)*\'/ 
			, _style: 'color: #C33;'
		}
		, string2 : { 
			  _match: /\"[^\"\\]*(?:\\.[^\"\\]*)*\"/
			, _style: 'color: #C33;'
		}
		, type    : { 
			  _match: /\b(?:[Ss][Ee][Ll][Ff]|[Nn][Uu][Ll][Ll]|[Tt][Rr][Uu][Ee]|[Ff][Aa][Ll][Ss][Ee]|[Dd][Ee][Cc][Ii][Mm][Aa][Ll]|[Ii][Nn][Tt][Ee][Gg][Ee][Rr]|[Ss][Tt][Rr][Ii][Nn][Gg]|[Dd][Aa][Tt][Ee]|[Bb][Oo][Oo][Ll][Ee][Aa][Nn]|[Xx][Mm][Ll]|[Aa][Rr][Rr][Aa][Yy]|[Dd][Uu][Rr][Aa][Tt][Ii][Oo][Nn]|[Mm][Aa][Pp]|[Pp][Aa][Ii][Rr]|[Tt][Aa][Gg])\b/
			, _style: 'color: #06C;'
		}
		, number  : { 
			  _match: /\b[+-]?(\d*\.?\d+|\d+\.?\d*)([eE][+-]?\d+)?\b/
			, _style: 'color: #90C;'
		}
		, parameter   : { 
			  _match: /-\w+/
			, _style: 'color: #36C;'
		}
		, variable: { 
			  _match: /\$\w+/
			, _style: 'color: #093;'
		}
		, local   : { 
			  _match: /#\w+/
			, _style: 'color: #093;'
		}
		, member  : { 
			  _match: /(?:->|&)\w+/
			, _style: 'color: #09F;'
		}
		, operator     : { 
			  _match: /[\+=,;\?\|@>\!\\\/\(\)\{\}:%\>\<&]/
			, _style: 'color: #000;'
		}
    } 
}